/* $Id: die.c,v 1.3 1999/10/11 14:24:34 cvs Exp $ */

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "color.h"

/* error handling :  die! die! die! */
void die (char *cs, ...)
{
  va_list ap;
  va_start(ap, cs);
  fprintf(stderr,"%sDIE%s: ", MY_COLOR_BRIGHT_RED, MY_COLOR_RED);
  vfprintf(stderr, cs, ap);
  fprintf(stderr, "%s\n\n", MY_COLOR_NORMAL);
  va_end(ap);
  exit(1);
}

void error( char *fn, char *cs, ... )
{
  va_list ap;
  /*
  if( !*fn || !*cs )
    return;
  */
  fprintf( stderr, "%s%s: %s", MY_COLOR_BRIGHT_RED, fn, MY_COLOR_RED );
  va_start(ap, cs);
  vfprintf(stderr, cs, ap);
  fprintf(stderr, "%s\n\n", MY_COLOR_NORMAL);
  va_end(ap);
  return;
}

void report( char *fn, char *cs, ... )
{
  va_list ap;
  if( *fn )
    fprintf( stderr, "%s%s: ", MY_COLOR_BRIGHT_YELLOW, fn );
  fprintf( stderr, "%s", MY_COLOR_YELLOW );
  va_start(ap, cs);
  vfprintf( stderr, cs, ap );
  fprintf( stderr, "%s", MY_COLOR_NORMAL );
  if( !strchr( cs, '\r' ) && !strchr( fn, '\r' ) )
    fprintf( stderr, "\n" );
  va_end(ap);
  return;
}
