/* $Id: eXimon.h,v 1.9 2000/02/01 13:19:56 cvs Exp $ */

/* include files, NO NEED TO EDIT */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include "color.h"


#ifdef DEBUG
  #include "debugg.h"
#else
  #include "config.h"
#endif


/* constants */
#define HAMLET             ((2b) || !(2b)) /* Shakespear */
#define MAX_FROZEN_MAILS   1000000
#define LEN_STR    	   1024
#define SML_STR    	   256
#define False 	   	   0
#define True       	   1
#define UNDEF      	   2
#define FOREVER    	   3
#define FROZEN     	   4
#define THAW      	   5
#define SPAM       	   6

/* frozen error codes */
#define EXIM_ID_LEN  16
#define FROZEN_1     "rate limit database"
#define FROZEN_1_LEN 18

#define NEARENUFF( a, b )	(  100*(a) <= (100+TOLERENCE)*(b) \
				|| 100*(a) >= (100-TOLERENCE)*(b) )

extern unsigned int     WARNING_LOAD;
extern unsigned int     HASH_TABLE_SIZE;
extern unsigned int     TOLERENCE;
extern unsigned int 	NO_HUMOUR;
extern unsigned int 	EXPERT;
extern unsigned int 	MOVE_FROZEN_MAILS;
extern unsigned int 	SPLIT_SPOOL_DIR;
extern unsigned int 	CHAR;
extern unsigned int 	NBR_FRLST;
extern char		PAGER[SML_STR];

typedef struct rtime rtime;
struct rtime {
  int m;			/* minutes */
  int h;			/* hours   */
  int d;			/* days    */
  int w;			/* weeks   */
};

typedef struct LIST LIST;
struct LIST {
  LIST          *next;		  /* obvious */
  char          exim_id[17];      /* size of the exim std IDS */
};

typedef struct MAIL_MSG MAIL_MSG;
struct MAIL_MSG {
  unsigned int  nbr_threads;      /* nbr of threaded messages */
  LIST          *list;		  /* IDs of threaded mails */
  unsigned int  nbr_rcpt;         /* how many on the rcpt list */
  unsigned int  size;             /* size of mail in blocks = 1024 bits */
  unsigned int  status;           /* FROZEN, THRALL or SPAM */
  rtime         *ttime;           /* julian date */
  char          IP[15];           /* size of most IPs */
  char          id[17];           /* size of the exim std IDS */
  char          usr[SML_STR];     /* username */
  char          subject[SML_STR]; /* subject of the mail */
};

typedef struct QUEUE_MAIL QUEUE_MAIL;
struct QUEUE_MAIL {
  MAIL_MSG      *msg;		  /* a mail message */
  QUEUE_MAIL    *next;		  /* collisions */
};




/* die.c */
void        die         (char *cs, ...);
void	    error	(char *fn, char *cs, ...);
void	    report	(char *fn, char *cs, ...);

/* mem.c */
void        * emalloc    (size_t sz);

/* mystrcasecmp.c */
int         mstrcmp     (char *s1, char *s2);

/* eXimon.c */
int         main        (int argc, char **argv);

/* usage */
void        usage       (void);

/* rcfile.c */
int         read_options(FILE *RCFILE);

/* read.c */
QUEUE_MAIL  *read_from_mailq  (QUEUE_MAIL *queue);

/* ncurses.c */
QUEUE_MAIL  *xcurs_voodoo ( QUEUE_MAIL *queue );

/* spawn.c */
int         spawn  	( QUEUE_MAIL *queue );
