/* $Id: rcfile.c,v 1.3 1999/10/11 14:24:34 cvs Exp $ */

#include "eXimon.h"
extern void chomp(char *s );


int read_options ( FILE * RCFILE ) {
  char *line = emalloc(sizeof(char) * SML_STR);
  char *tmp;

  while ( fgets(line, SML_STR, RCFILE) ) {
    
    /* comment line */
    if ( line[0] == '#' || line[0] == '\n') continue;

    /* normal line */
    tmp = &line[0];
    while ( *tmp == ' ' ) tmp++;
	
    /* spaces */
    if ( *tmp == '\n' ) continue; /* fool check */

    /* load */
    if ( !strncmp(tmp, "WARNING_LOAD",12)) {
      tmp = strchr(tmp, '=') + 1;
      while ( *tmp == ' ' ) tmp++;
      WARNING_LOAD = atoi(tmp);

    /* size of hash table */
    } else if ( !strncmp(tmp, "HASH_TABLE_SIZE",15)){
      tmp = strchr(tmp, '=') + 1;
      while ( *tmp == ' ' ) tmp++;
      HASH_TABLE_SIZE = atoi(tmp);

    /* tolerence in grouping mails */
    } else if ( !strncmp(tmp, "TOLERENCE", 9)){
      tmp = strchr(tmp, '=') + 1;
      while ( *tmp == ' ' ) tmp++;
      TOLERENCE = atoi(tmp);

    /* what pager to use */
    } else if ( ! strncmp(tmp, "PAGER", 5)) {
      fprintf(stderr, "due to a security flaw, this option has been frozen\n");
      fprintf(stderr, "\aHit any ket to continuw...");
      getc(stdin);
      /*
      tmp = strchr(tmp, '=') + 1;
      strcpy(PAGER, tmp);
      chomp(PAGER);
      */

    /* no humour git! */
    } else if ( ! strncmp(tmp, "NO_HUMOUR", 9)) {
      NO_HUMOUR = True;

    /* expert at it */
    } else if ( ! strncmp(tmp, "EXPERT", 6)) {
      EXPERT = True;

    /* move frozen mails */
    } else if ( ! strncmp(tmp, "MOVE_FROZEN_MAILS", 17)) {
      MOVE_FROZEN_MAILS = True;

    /* split spool dir */
    } else if ( ! strncmp(tmp, "SPLIT_SPOOL_DIR", 15) ) {
      SPLIT_SPOOL_DIR = True;
    
    /* default */
    } else {
      error(NULL,"there is no option called \"%s\", this line has been ignored!", tmp);
      error(NULL,"hit any key to continue");
      getchar();
    }
  }

  /* all ends well */
  free(line);
  return EXIT_SUCCESS;
}
