/* $Id: xcurses.c,v 1.10 2000/01/31 16:42:09 cvs Exp $ */

/***************************************************************************
*                            COPYRIGHT NOTICE                              *
****************************************************************************
*                ncurses is copyright (C) 1992-1995                        *
*                          Zeyd M. Ben-Halim                               *
*                          zmbenhal@netcom.com                             *
*                          Eric S. Raymond                                 *
*                          esr@snark.thyrsus.com                           *
*                                                                          *
*        Permission is hereby granted to reproduce and distribute ncurses  *
*        by any means and for any fee, whether alone or as part of a       *
*        larger distribution, in source or in binary form, PROVIDED        *
*        this notice is included with any such distribution, and is not    *
*        removed from any of its header files. Mention of ncurses in any   *
*        applications linked with it is highly appreciated.                *
*                                                                          *
*        ncurses comes AS IS with no warranty, implied or expressed.       *
*                                                                          *
***************************************************************************/


/***************************************************************************
*                              NCURSES IS EVIL                             *
***************************************************************************/

#include "xcurses.h"
extern int errno; /* error numner */

/* don't ask! */
static void finish( int sig ) { endwin(); }
static void mclear( void    ) { move(0,0); clrtobot(); }

/* print a mail */
char * lpr_msgs ( MAIL_MSG * mail ) {
  char *line = emalloc( sizeof(char) * 81 );
  char date[5];
  char stat = 'U';
  char size[10], rcpt[10], sub[25], usr[30];
  
  /* date */
  if ( !mail->ttime->w ) {
    if ( !mail->ttime->d ) {
      if ( !mail->ttime->h ) { sprintf(date, "%dm", mail->ttime->m );
      } else { sprintf(date, "%dh", mail->ttime->h ); }
    } else { sprintf(date, "%dd", mail->ttime->d ); }
  } else { sprintf(date, "%dw", mail->ttime->w ); }

  /* status */
  if      ( mail->status == FROZEN) { stat = 'F';}
  else if ( mail->status == THAW ) { stat = 'T';}
  else if ( mail->status == SPAM  ) { stat = 'S';}
  else    { die("You have corrupted data... PANIC!"); }

  /* size */
  if ( mail->size > 999 ) {
    if ( mail->size > 999999 ) {
      if ( mail->size > 999999999 ) {
        sprintf(size, ">1g");
      } else {
        sprintf(size, "%3dm", (int)(mail->size * 0.00001));
      }
    } else {
      sprintf(size, "%3dk", (int)(mail->size * 0.001));
    }
  } else {
    sprintf(size, "%3db", mail->size);
  }

  /* rcpt */
  mail->nbr_rcpt > 999 ? sprintf(rcpt,">1K"):sprintf(rcpt,"%3d",mail->nbr_rcpt);
  
  /* sub */
  if ( strlen(mail->subject) >= 22 ) {
    sprintf(sub, "%.22s$", mail->subject);
  } else {
    strcpy(sub, mail->subject);
  }

  /* usr */
  if ( strlen(mail->usr) >= 29 ) {
    sprintf(usr, "%.29s$", mail->usr);
  } else {
    strcpy(usr, mail->usr);
  }
  
  /* main line */
  sprintf(line
          ,"%c %3d %3.3s %4s %s %30.30s  %.23s\n"
	  ,stat
	  ,mail->nbr_threads
	  ,date
	  ,size
	  ,rcpt
	  ,usr
	  ,sub
	  );

  /* print it! */
  /*
  fprintf(stderr, "%s", line);
  fflush(NULL);
  */
  return line;
}


/* init curses */
int xcurs_init ( void ) {
  int y, x;

  (void) signal(SIGINT, finish);/* arrange interrupts to terminate */
  (void) initscr();      	/* initialize the curses library */
  keypad(stdscr, TRUE);  	/* enable keyboard mapping */
  (void) nonl();         	/* tell curses not to do NL->CR/NL on output */
  (void) cbreak();       	/* take input chars one at a time */
  (void) noecho();       	/* don't echo input */

  if (has_colors()) {
    start_color();

   /* Simple color assignment, often all we need.  */
   init_pair(COLOR_BLACK,   COLOR_BLACK,   COLOR_BLACK);
   init_pair(COLOR_GREEN,   COLOR_GREEN,   COLOR_BLACK);
   init_pair(COLOR_RED,     COLOR_RED,     COLOR_BLACK);
   init_pair(COLOR_CYAN,    COLOR_CYAN,    COLOR_BLACK);
   init_pair(COLOR_WHITE,   COLOR_WHITE,   COLOR_BLACK);
   init_pair(COLOR_MAGENTA, COLOR_MAGENTA, COLOR_BLACK);
   init_pair(COLOR_BLUE,    COLOR_BLUE,    COLOR_BLACK);
   init_pair(COLOR_YELLOW,  COLOR_YELLOW,  COLOR_BLACK);
  }

  getmaxyx(stdscr, y, x);
  if ( x < 80 ) {
    finish(0);
    die("eXimon runs on a 80 chars window, yours is only %d...", x);
  }

  return EXIT_SUCCESS;
}

/* redraw the menu */
MENU * xcurs_redraw_menu ( 
			MENU *menu,
			QUEUE_MAIL *queue,
			int count,
			MAIL_MSG *index[]
			) {
  int i, x, y, nbr_fr;
  char **tmp, **tmp1;
  char tmp2[10];
  char *line[HASH_TABLE_SIZE];
  char *name[HASH_TABLE_SIZE];
  MAIL_MSG *pmsg;
  QUEUE_MAIL *qpt;
  ITEM *items[HASH_TABLE_SIZE+1];

  if ( !menu )
    free_menu(menu);

  /*
  line[0] = "hello";
  name[0] = "test";
  items[0]= new_item( name[0], line[0]);
  */

  for ( count = 0, nbr_fr = 0, i = 0; i < HASH_TABLE_SIZE; i++ ) {
    for ( qpt = &queue[i]; qpt != NULL;  qpt = qpt->next ) {
      if ( (pmsg = qpt->msg) != NULL ) {
        nbr_fr++;
        line[count] = emalloc( 81 );
        tmp = &line[count];
        *tmp = lpr_msgs(pmsg);
        chomp(*tmp); /* bug fix */
	name[count] = emalloc( 4 ); 
	tmp1 = &name[count];
	sprintf(*tmp1, "%3d", count);
        items[count] = new_item( name[count], line[count]);
	index[count] = pmsg; /* for later use */
        count++;
      }
    }
  }
  items[count] = NULL;
  menu = new_menu(items);

  /* set menu format */
  getmaxyx(stdscr, y, x);
  set_menu_format(menu, y-2, 0);
  post_menu(menu);

  /* help line & stuff */
  color_set(COLOR_GREEN, NULL);
  mvaddstr(y-2, 0, "eXimon:  Number frozen[threaded] = ");
  color_set(COLOR_RED, NULL);
  sprintf(tmp2, "%4d", nbr_fr);
  mvaddstr(y-2, 36, tmp2);
  color_set(COLOR_GREEN, NULL);
  mvaddstr(y-2, 41, "[");
  color_set(COLOR_RED, NULL);
  sprintf(tmp2, "%4d", NBR_FRLST);
  mvaddstr(y-2, 42, tmp2);
  color_set(COLOR_GREEN, NULL);
  mvaddstr(y-2, 47, "]");
  mvaddstr(y-1, 9, "Help:'?' Thaw:'t' Spam:'s' View Header:'h' View Data:'d' Quit:'q'");
  color_set(COLOR_RED, NULL);
  refresh();

  return menu;
}

/* help function */
void help ( void ) {
  int i = 0 ;

  color_set(COLOR_RED, NULL);
  mvaddstr(i++,0,"eXimon:\n");
  color_set(COLOR_MAGENTA, NULL);
  mvaddstr(i++,0,"\t\t\tHelp Index\n\n\n");
  mvaddstr(i++,0,"List of Commands:\n");
  
  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   s");
  color_set(COLOR_RED, NULL);
  mvaddstr(i, 13, "SPAM SAVES");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 24, "a message -- Be careful with this one.");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   t");
  color_set(COLOR_RED, NULL);
  mvaddstr(i, 13, "THAWS");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 19, "a message -- Be careful with this one.");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   f");
  color_set(COLOR_RED, NULL);
  mvaddstr(i, 13, "FREEZE");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 20, "a message -- Be careful with this one.");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   i");
  color_set(COLOR_RED, NULL);
  mvaddstr(i, 13, "IP SPAM SAVE");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 26, "all msgs based on IP -- Be careful with this one.");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   t");
  color_set(COLOR_RED, NULL);
  mvaddstr(i, 13, "SUBJECT SPAM SAVE");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 31, "all msgs on subject -- Be careful with this one.");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   q");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i, 4, " or ");
  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 8, "e");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 13, "quits or exits respectivly,");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   k");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i, 13, "goes up, can use");
  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 30, "up arrow");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 39, "as well,");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   j");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i, 13, "goes down, can use");
  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 32, "down arrow");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 43, "as well,");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   Page Up");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 13, "scrolls a page in the ``up'' direction,");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   Page Down");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 13, "scrolls a page in the ``down'' direction,");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   a");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 13, "goto the first entry (alpha),");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   o");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 13, "goto the last entry (omega),");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   d");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i, 13, "displays the data file, can use");
  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 45, "space");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i, 51, "or/and");
  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 58, "enter");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 64, "as well,");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   h");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 13, "displays the header file,");

  color_set(COLOR_CYAN, NULL);
  mvaddstr(i, 0, "   ?");
  color_set(COLOR_GREEN, NULL);
  mvaddstr(i++, 13, "prints this help.");

  color_set(COLOR_MAGENTA, NULL);
  mvaddstr(i++, 0, "In case of problems, please contact:");
  color_set(COLOR_BLUE, NULL);
  mvaddstr(i, 5, "<yann@theplanet.net>");
  color_set(COLOR_MAGENTA, NULL);
  mvaddstr(i, 25, " or ");
  color_set(COLOR_BLUE, NULL);
  mvaddstr(i, 29, "<johnd@theplanet.net>");
  color_set(COLOR_MAGENTA, NULL);
  mvaddstr(i++, 50, ".");

  color_set(COLOR_MAGENTA, NULL);
  mvaddstr(i++,0, "Hit any key to return to main eXimon menu\n");
}

/* Voodoo Curses */
QUEUE_MAIL * xcurs_voodoo ( QUEUE_MAIL *queue ) {
  MAIL_MSG *index[2*HASH_TABLE_SIZE]; /* NOT GOOD ENOUGH */
  MAIL_MSG *pmsg;
  MENU *menu = NULL;
  QUEUE_MAIL *qpt;
  char tmp[SML_STR];
  int count = 0, line_count = 0;
  int i, c, x, y;

  /* ini it all */
  xcurs_init();

  /* menu */
  menu = xcurs_redraw_menu(menu, queue, count, index);
  
  /* input loop */
  for (;;) {
    c = getch();     /* refresh, accept single keystroke of input */
    if( isalpha( c ) )
      c = tolower( c );

    /* resizing the term window */
    if ( c == KEY_RESIZE || c == SIGWINCH ) {
      getmaxyx(stdscr, y, x);
      if ( x < 80 ) {
        finish(0);
        die("eXimon runs on a 80 chars window, yours is only %d...", x);
      }
      resizeterm(y, x);

    /* quit || exit */
    } else if ( c == 'q' || c == 'e' ) { 
      break ;

    /* up and down */
    } else if ( c == 'k' || c == KEY_UP ) {
      menu_driver(menu, REQ_UP_ITEM);
    } else if ( c == 'j' || c == KEY_DOWN ) {
      menu_driver(menu, REQ_DOWN_ITEM);
    
    /* next and prev */
    } else if ( c == KEY_NPAGE ) {
      menu_driver(menu, REQ_SCR_DPAGE);
    } else if ( c == KEY_PPAGE ) {
      menu_driver(menu, REQ_SCR_UPAGE);

    /* first and last */
    } else if ( c == 'a') {
      menu_driver(menu, REQ_FIRST_ITEM);
    } else if ( c == 'o') {
      menu_driver(menu, REQ_LAST_ITEM);
    
    /* spam save */
    } else if ( c == 's' ) {
      pmsg = index[(line_count = (item_index(current_item(menu))))];
      pmsg->status = SPAM;
      menu = xcurs_redraw_menu(menu, queue, count, index);
      for ( i = 0; i < line_count+1; i++ ) menu_driver(menu, REQ_DOWN_ITEM);

    /* thaw */
    } else if ( c == 't' ) {
      pmsg = index[(line_count = (item_index(current_item(menu))))];
      pmsg->status = THAW;
      menu = xcurs_redraw_menu(menu, queue, count, index);
      for ( i = 0; i < line_count+1; i++ ) menu_driver(menu, REQ_DOWN_ITEM);

    /* freeze */
    } else if ( c == 'f' ) {
      pmsg = index[(line_count = (item_index(current_item(menu))))];
      pmsg->status = FROZEN;
      menu = xcurs_redraw_menu(menu, queue, count, index);
      for ( i = 0; i < line_count+1; i++ ) menu_driver(menu, REQ_DOWN_ITEM);

    /* IP spam save ... oh shite. */  
    } else if ( c == 'i' ) {

      /* get line */
      pmsg = index[(line_count = (item_index(current_item(menu))))];
      mclear();

      /* print warning message */
      i = 0;
      color_set(COLOR_RED, NULL);
      mvaddstr(i++,0,"W A R N I N G :");
      color_set(COLOR_GREEN, NULL);
      mvaddstr(i,0,"The following will spam save");
      color_set(COLOR_RED, NULL);
      mvaddstr(i,29,"ALL");
      color_set(COLOR_GREEN, NULL);
      mvaddstr(i++,33,"messages coming from IP:");
      color_set(COLOR_YELLOW, NULL);
      snprintf(tmp, SML_STR, "\"%s\"", pmsg->IP);
      mvaddstr(i++,23,tmp);
      color_set(COLOR_RED, NULL);
      mvaddstr(i++,0,"Press `Y' to continue, any other key to abort!\n");

      /* do voodoo magic, even down chains */
      if ( getch() == 'y' ) {
        for ( i = 0; i < HASH_TABLE_SIZE; i++ ) {
	  if ( queue[i].msg ) {
	    for ( qpt = &queue[i]; qpt != NULL; qpt = qpt->next ) {
	      if ( !mstrcmp(pmsg->IP, qpt->msg->IP) ) {
	        qpt->msg->status = SPAM;
	      }
	    }
	  }
	}
      } 

      /* all done */
      mclear();
      menu = xcurs_redraw_menu(menu, queue, count, index);
      for ( i = 0; i < line_count+1; i++ ) menu_driver(menu, REQ_DOWN_ITEM);


    /* topic (read: subject) spam save. */  
    } else if ( c == 'z' ) {

      /* get line */
      pmsg = index[(line_count = (item_index(current_item(menu))))];
      mclear();

      /* print warning message */
      i = 0;
      color_set(COLOR_RED, NULL);
      mvaddstr(i++,0,"W A R N I N G :");
      color_set(COLOR_GREEN, NULL);
      mvaddstr(i,0,"The following will spam save");
      color_set(COLOR_RED, NULL);
      mvaddstr(i,29,"ALL");
      color_set(COLOR_GREEN, NULL);
      mvaddstr(i++,33,"messages with a subject line of:");
      color_set(COLOR_YELLOW, NULL);
      snprintf(tmp, SML_STR, "\"%s\"", pmsg->subject);
      mvaddstr(i++,23,tmp);
      color_set(COLOR_RED, NULL);
      mvaddstr(i++,0,"Press `Y' to continue, any other key to abort!\n");

      /* do voodoo magic, even down chains */
      if ( getch() == 'y' ) {
        for ( i = 0; i < HASH_TABLE_SIZE; i++ ) {
	  if ( queue[i].msg ) {
	    for ( qpt = &queue[i]; qpt != NULL; qpt = qpt->next ) {
	      if ( !mstrcmp(pmsg->subject, qpt->msg->subject) ) {
	        qpt->msg->status = SPAM;
	      }
	    }
	  }
	}
      } 

      /* all done */
      mclear();
      menu = xcurs_redraw_menu(menu, queue, count, index);
      for ( i = 0; i < line_count+1; i++ ) menu_driver(menu, REQ_DOWN_ITEM);

    /* display message message */
    } else if ( c == ' ' || c == 'h' || c == 'd' || c == '\r' ) {
      char command[SML_STR], dump[SML_STR];
      char tmp_str;
      char WHAT = ( c == 'h' ) ? 'H' : 'D'; /* header or data ? */
      
      /* find message */
      pmsg = index[(line_count = (item_index(current_item(menu))))];
      mclear();
      def_prog_mode(); /* save tty */
      endwin();
      tmp_str = ( SPLIT_SPOOL_DIR )? pmsg->id[5] : '/';
      sprintf(dump, "%s/%c/%s-%c"
        ,( MOVE_FROZEN_MAILS ) ? BASE_DIR_FINPUT : BASE_DIR_INPUT
	,tmp_str
	,pmsg->id
	,WHAT
      );
      sprintf(command, "%s %s", PAGER, dump); /* prints message */
      system(command); /* runs pager and stuff */
      mclear();
      refresh();
      menu = xcurs_redraw_menu(menu, queue, count, index);
      for ( i = 0; i < line_count; i++ ) menu_driver(menu, REQ_DOWN_ITEM);

    /* the help menu... yeah, yeah, yeah... who needs help? */
    } else if ( c == '?' ) { 
      pmsg = index[(line_count = (item_index(current_item(menu))))];
      mclear();
      help();
      getch();
      mclear();
      menu = xcurs_redraw_menu(menu, queue, count, index);
      for ( i = 0; i < line_count; i++ ) menu_driver(menu, REQ_DOWN_ITEM);

    /* do nothing */
    } else {
      pmsg = index[(line_count = (item_index(current_item(menu))))];
      mclear();
      mvaddstr(0,0,"RTFM: No such function.");
      mvaddstr(1,0,"Press any key to return to main menu");
      getch();
      menu = xcurs_redraw_menu(menu, queue, count, index);
      for ( i = 0; i < line_count; i++ ) menu_driver(menu, REQ_DOWN_ITEM);
    }
  }
  
  /* end of ncurses */
  mclear();
  refresh();
  finish(0);

  /* gives back modified list */
  return queue;
}
