./ ADD NAME=ADDMEM
/* REXX - mimic simple IEBUPDTE ./ ADD operation for FB/VB and
   whatever LRECL input/output on a z/OS/TSO environment.
   Note that this utility is very limitted in nature and there was no
   attempt to optimize its operation.
   This utility supports only the ./ ADD NAME=member operation of IEBUPDTE
   It assumes that the output library is pre-allocated and is the same format
   as the input file.  It intends to support only RECFM=F|FB|V|VB           */
/* Version 0.1 */
/*           Copyright (c) 2012 Ze'ev Atlas

-----------------------------------------------------------------------------
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

    * Neither the name of the University of Cambridge nor the names of its
      contributors may be used to endorse or promote products derived from
      this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
-----------------------------------------------------------------------------
*/
  MAIN:
   /* usage: Rexx addmem input-file-name output-lib-name*/
   PARSE ARG ifile olib .
   say "ADDMEM-001 add input file" ifile "to library" olib
   call A00_OPTIONAL
   Call A01_OPEN_FILES
   Call B01_INITIALISATION
   Call C01_PROCESS
   Call D01_TERMINATION
   Call EXITCMD

   Return

  A00_OPTIONAL:
   "execio * diskr TRANSLAT (stem parmin. finis"
   p=0
   if parmin.0 > 0 then
   do
      tistr = ''
      tostr = ''
      p = 1
      do while p \> parmin.0
         parse var parmin.p pi po
          interpret "ti=" pi
          interpret "to=" po
          tistr=tistr || ti
          tostr=tostr || to
          p = p+1
      end
   end

   return

  A01_OPEN_FILES:
    "ALLOC F(INFILE) DA('" || ifile || "') SHR REU"
    /* check for RC */
    IF RC \= 0 THEN
       call DIE 'alloc input failed' RC
    "execio 1 diskr INFILE ("
    /* check for RC */
    if RC = 2 then
    do
       say "ADDMEM-002 EMPTY input file" ifile
       Final_RC = RC
       call EXITCMD
    end
    IF RC \= 0 THEN
       call DIE 'open input failed' RC
    parse pull iline

   return

 B01_INITIALISATION:

    Final_RC = 0
    openfile = 0

   Return

 EXITCMD:
    /* To show the return code when running in ispf */
    If Final_RC = 0 Then
       Do
         Say "Successful Completition "
       End
    Else
       Say "Unsuccessful Completition"
    Exit Final_RC

   Return

C01_PROCESS:
    do forever
      if substr(iline, 1, 3) = './ ' then
      do
         if openfile = 1 then
         do
            "execio * diskw OUTFILE (stem orecs. finis"
            /* check for RC */
            IF RC \= 0 THEN
               call DIE 'write\close output failed for member ' || vmember RC
            "FREE FI(OUTFILE)"
            IF RC \= 0 THEN
               call DIE 'free output failed for member ' || vmember RC
            openfile = 0
         end
         parse VAR iline . vadd vname '=' vmember .
         "ALLOC F(OUTFILE) DA('" || olib || "(" || vmember || ")') SHR REU"
         /* check for RC */
         IF RC \= 0 THEN
               call DIE 'alloc output failed for member ' || vmember RC
         drop orecs.
         orecs.0 = 0
         say "ADDMEM-004 adding member" vmember
         openfile = 1
      end
      else
      do
         orecs.0 = orecs.0 + 1
         n = orecs.0
         if p > 0 then
         do
            iline = translate(iline,tostr,tistr)
         end
         orecs.n = iline
      end
      "execio 1 diskr INFILE ("
      /*if eof leave*/
      if RC = 2 then
         leave
      /* check for RC */
      IF RC \= 0 THEN
            call DIE 'read input failed' RC
      parse pull iline
   end

    Return

 D01_Termination:
   if openfile = 1 then
   do
      "execio * diskw OUTFILE (stem orecs. finis"
      /* check for RC */
      IF RC \= 0 THEN
               call DIE 'write\close output failed for member ' || vmember RC
       "FREE FI(OUTFILE)"
      IF RC \= 0 THEN
               call DIE 'free output failed for member ' || vmember RC
      openfile = 0
   end
   "execio 0 diskr INFILE (finis"
   IF RC \= 0 THEN
               call DIE 'close input failed' RC
   /* check for RC */
    "FREE FI(INFILE)"
    IF RC \= 0 THEN
               call DIE 'free input failed' RC
    final_RC=0

   Return

DIE:
   parse arg msg vrc .
   say "ADDMEM-003" || msg vrc

   final_RC = vrc
   call EXITCMD

   return
