<?php
/**
 * footer.tpl
 *
 * Template of the footer for each page.
 *
 * @copyright &copy; 1999-2006 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: page_header.tpl 12631 2007-08-30 02:10:25Z pdontthink $
 * @package squirrelmail
 * @subpackage templates
 */

/* retrieve the template vars */
extract($t);

if (isset($startMessage) && isset($shortBoxName)) {

$current_folder_str = '';
if (isset($shortBoxName) &&  $shortBoxName != '' ) {
    $current_folder_str .= _("Current Folder") . ": <em>$shortBoxName&nbsp;</em>\n";
} else {
    $current_folder_str .= '&nbsp;';
}


// Define our default link text.
$signout_link_default = _("Sign Out");
$compose_link_default = _("Compose");
$address_link_default = _("Addresses");
$folders_link_default = _("Folders");
$options_link_default = _("Options");
$search_link_default = _("Search");
$help_link_default = _("Help");
$msg_list_default = _("Message List");

/*
 * Create strings to use for links.  If tempalte authors
 * wish to use images instead, they may change the values
 * below to img tags.

 * Example w/ image:
 * $compose_str = '<img src="compose.png" border="0" ' .
 *				  'alt="'.$compose_link_default.'" ' .
 *				  'title="'.$compose_link_default.'" />';
 */

$signout_str = $signout_link_default;
$compose_str = $compose_link_default;
$address_str = $address_link_default;
$folders_str = $folders_link_default;
$options_str = $options_link_default;
$search_str = $search_link_default;
$help_str = $help_link_default;


$compose_link	= makeComposeLink ('src/compose.php?mailbox='.$urlMailbox.'&amp;startMessage='.$startMessage, $compose_str);
$signout_link	= makeInternalLink ('src/signout.php', $signout_str, $frame_top);
$address_link	= makeInternalLink ('src/addressbook.php', $address_str);
$folders_link	= makeInternalLink ('src/folders.php', $folders_str);
$search_link	= makeInternalLink ('src/search.php?mailbox='.$urlMailbox, $search_str);
$options_link	= makeInternalLink ('src/options.php', $options_str);
$help_link		= makeInternalLink ('src/help.php', $help_str);
if ($aMailbox)
	$msg_list_href = get_message_list_uri($aMailbox['NAME'], $startMessage, $what);

?>
<div id="page_footer">
<!-- Begin Footer Navigation Table -->
<?php echo $compose_link; ?><br />
<?php echo $address_link; ?><br />
<?php echo $folders_link; ?><br />
<?php echo $options_link; ?><br />
<?php echo $search_link; ?><br />
<?php echo $help_link; ?><br />

<?php

if (!empty($plugin_output['menuline']))
	echo $plugin_output['menuline'];
if (!empty($plugin_output['provider_link_before']))
	echo $plugin_output['provider_link_before'];
if (!empty($provider_link))
	echo $provider_link;
if (!empty($plugin_output['provider_link_after']))
	echo $plugin_output['provider_link_after'];

?>
<hr />
<?php echo $signout_link; ?>
<hr />
<!-- End Header Navigation Table -->

<?php if (isset($hide_sm_attributions) && !$hide_sm_attributions): ?>
<p class="sqm_squirrelcopyright">
    &copy; 1999-2007 The SquirrelMail Project Team
    - <a href="about.php">About SquirrelMail</a>
</p>
<?php endif; ?>

<?php } ?>

</html>
</body>
