<?php
/**
 * login.tpl
 *
 * Template to create the login page
 *
 * The following variables are available to this template:
 *      $logo_str           - string containing HTML to display the org logo
 *      $logo_path          - path to the org logo, in case you want to do
 *                            something else with it.
 *      $sm_attribute_str   - string containg SQM attributes.  Will be empty if
 *                            this has been disabled by the admin.
 *      $org_name_str       - translated string containing orginization's name
 *      $login_field_value  - default value for the user name field
 *      $login_extra        - Some extra form fields needed by SquirrelMail
 *                            for the login.  Template designers SHOULD ALWAYS
 *                            INCLUDE this value somewhere in the form.
 *      $plugin_output      - An array of extra output that may be added by 
 *                            plugin(s).
 * 
 * @copyright &copy; 1999-2006 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: login.tpl 12145 2007-01-19 09:10:10Z pdontthink $
 * @package squirrelmail
 * @subpackage templates
 */

/* retrieve the template vars */
extract($t);

/*
 * force mobile logo for debug.
 */

$logo_str = "<img src=\"../templates/mobile_default/images/smm_logo.gif\" />\n";


echo $logo_str; if (!empty($logo_str)) echo '<br />'; 

echo $org_name_str;

echo "<hr />\n";
echo "<br />\n";

echo _("Name:");
echo "<br />\n";
echo '<input type="text" name="login_username" value="';
echo   $login_field_value;
echo '" id="login_username" format="*m" />';
echo "<br />\n";

echo _("Password:");
echo "<br />\n";
echo '<input type="password" name="secretkey" value="" id="secretkey" format="*m" />';
echo "<br />\n";

echo $login_extra;

if (!empty($plugin_output['login_form'])) echo $plugin_output['login_form'];

echo '<input type="submit" value="' . _("Login") . '" />';
echo '<br /><br />';

echo nl2br($sm_attribute_str);

?>
