<?php

/**
 * message_list.tpl
 *
 * Template for viewing a messages list
 *
 * The following variables are available in this template:
//FIXME: need to clean (and document) this list, it is just a dump of the array keys of $t
 *    $sTemplateID
 *    $icon_theme_path
 *    $javascript_on
 *    $delayed_errors
 *    $frames
 *    $lang
 *    $page_title
 *    $header_tags
 *    $plugin_output
 *    $header_sent
 *    $body_tag_js
 *    $shortBoxName
 *    $provider_link
 *    $frame_top
 *    $urlMailbox
 *    $startMessage
 *    $hide_sm_attributions
 *    $uri
 *    $text
 *    $onclick
 *    $class
 *    $id
 *    $target
 *    $color
 *    $form_name
 *    $form_id
 *    $page_selector
 *    $page_selector_max
 *    $messagesPerPage
 *    $showall
 *    $end_msg
 *    $align
 *    $iNumberOfMessages
 *    $aOrder
 *    $aFormElements
 *    $sort
 *    $pageOffset
 *    $baseurl
 *    $aMessages
 *    $trash_folder
 *    $sent_folder
 *    $draft_folder
 *    $thread_link_uri
 *    $thread_name
 *    $php_self
 *    $mailbox
 *    $enablesort
 *    $icon_theme
 *    $use_icons
 *    $alt_index_colors
 *    $fancy_index_highlite
 *    $aSortSupported
 *    $show_label_columns
 *    $compact_paginator
 *    $aErrors
 *    $checkall
 *    $preselected
 *
 * @copyright &copy; 1999-2006 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: message_list.tpl 12697 2007-09-25 04:49:39Z pdontthink $
 * @package squirrelmail
 * @subpackage templates
 */


/** add required includes */
include_once(SM_PATH . 'functions/template/message_list_util.php');


/* retrieve the template vars */
extract($t);


if (!empty($plugin_output['mailbox_index_before']))
	echo $plugin_output['mailbox_index_before'];


echo '<h1>'. _("Message List") . "</h1>\n";

?>
<hr />
<div id="message_list">
<!-- Message headers start -->
<?php

/* Overwrite aOrder in preferences */
$aOrder = array(
	SQM_COL_FROM, SQM_COL_INT_DATE,
	SQM_COL_FLAGS, SQM_COL_PRIO, SQM_COL_ATTACHMENT, SQM_COL_SUBJ
);
$iColCnt = count($aOrder);

/**
 * main message iteration loop
 */
$i = 0;
foreach ($aMessages as $iUid => $aMsg) {

	/**
	 * Display message header row in messages list
	 *
	 */

	$aColumns = $aMsg['columns'];


	/**
	 * Check the flags and set a class var.
	 */
	if (isset($aColumns[SQM_COL_FLAGS])) {
		$aFlags = $aColumns[SQM_COL_FLAGS]['value'];
		$sFlags = mobile_getFlagIcon($aFlags, $icon_theme_path);

		/* add the flag string to the value index */
		$aColumns[SQM_COL_FLAGS]['value'] = $sFlags;
	}
	/**
	 * Check the priority column
	 */
	if (isset($aColumns[SQM_COL_PRIO])) {
		$sValue = mobile_getPriorityIcon($aColumns[SQM_COL_PRIO]['value'], $icon_theme_path);
		$aColumns[SQM_COL_PRIO]['value'] = $sValue;
	}

	/**
	 * Check the attachment column
	 */
	if (isset($aColumns[SQM_COL_ATTACHMENT])) {
		$sValue = mobile_getAttachmentIcon($aColumns[SQM_COL_ATTACHMENT]['value'], $icon_theme_path); 
		$aColumns[SQM_COL_ATTACHMENT]['value'] = $sValue;
	}

	// flag style mumbo jumbo
	$sPre = $sEnd = '';
	if (isset($aColumns[SQM_COL_FLAGS])) {
		if (!in_array('seen',$aFlags) || !$aFlags['seen']) {
			$sPre = '<span class="unread">'; $sEnd = '</span>';
		}
		if (in_array('deleted',$aFlags) && $aFlags['deleted']) {
			$sPre = '<span class="deleted">' . $sPre;
			$sEnd .= '</span>';
		} else {
			if (in_array('flagged',$aFlags) && $aFlags['flagged']) {
				$sPre = '<span class="flagged">' . $sPre;
				$sEnd .= '</span>';
			}
		}
	}
	/**
	 * Because the order of the columns and which columns to show is a user preference
	 * we have to do some php coding to display the columns in the right order
	 */
	foreach ($aOrder as $iCol) {
		if (in_array($iCol, $show_label_columns)) {
			$sLabelStart = '<label for="'.$form_id."_msg$i\">";
			$sLabelEnd = '</label>';
		} else {
			$sLabelStart = '';
			$sLabelEnd = '';
		}
		$aCol       = (isset($aColumns[$iCol]))    ? $aColumns[$iCol]    : array();
		$title      = (isset($aCol['title']))      ? $aCol['title']      : '';
		$link       = (isset($aCol['link']))       ? $aCol['link']       : '';
		$link_extra = (isset($aCol['link_extra'])) ? $aCol['link_extra'] : '';
		$value      = (isset($aCol['value']))      ? $aCol['value']      : '';
		$target     = (isset($aCol['target']))     ? $aCol['target']     : '';
		if ($iCol !== SQM_COL_CHECK) {
			$value = $sLabelStart.$sPre.$value.$sEnd.$sLabelEnd;
		}

		switch ($iCol) {
			case SQM_COL_SUBJ:
				echo '<span class="col_subject">';
				echo '<a href="'.mobile_add_session_param($link).'"';
				echo ' title="' . _("Show") . '"';
				if ($link_extra) { echo ' ' . $link_extra;     }
				echo '>' . $value . '</a></span><br />' . "\n";
				echo "</div>\n";
				break;
			case SQM_COL_FLAGS:
				echo '<div style="white-space:nowrap">';
				echo '<span class="col_flags">'.$value."</span>\n";
				break;
			case SQM_COL_INT_DATE:
			case SQM_COL_DATE:
				echo '<span class="col_date">'.$value."</span><br />\n";
				break;
			case SQM_COL_FROM:
				echo '<div style="white-space:nowrap">';
				echo '<span class="col_text"';
				if ($link) {
					echo '><a href="'.$link.'"';
					if ($target) { echo ' target="'.$target.'"'; }
					if ($title)  { echo ' title="'.$title.'"';   }
				} else {
					if ($title) { echo ' title="'.$title.'"';   }
				}
				echo '>';
				echo $value;
				if ($link) {
					echo '</a>';
				}
				echo "</span></div>\n";
				break;
			default:
				echo '<span class="col_text"';
				if ($link) {
					echo '><a href="'.mobile_add_session_param($link).'"';
					if ($target) { echo ' target="'.$target.'"'; }
					if ($title)  { echo ' title="'.$title.'"';   }
					echo '>';
				} else {
					if ($title) { echo ' title="'.$title.'"';   }
					echo '>';
				}
				echo $value;
				if ($link) {
					echo '</a>';
				}
				echo "</span>\n";
				break;
		}
	}

	echo "<hr />\n";
	$i++;

}

/**
 * Calculate string "Viewing message x to y (z total)"
 */
$msg_cnt_str = '';
if ($pageOffset < $end_msg) {
    $msg_cnt_str = sprintf(_("Viewing %s-%s of %s"),
                           '<em>' . $pageOffset . '</em>',
                           '<em>' . $end_msg . '</em>',
                           $iNumberOfMessages);
} else if ($pageOffset == $end_msg) {
    $msg_cnt_str = sprintf(_("Viewing %s of %s"),
                           '<em>' . $pageOffset . '</em>',
                           $iNumberOfMessages);
}
if (!empty($msg_cnt_str)) {
	echo '<p><center>';
	echo $msg_cnt_str;
	echo "<br />";
	echo $this->fetch('paginator.tpl');
	echo "</center></p><hr />\n";
}


?>
<!-- Message headers end -->
</div>
