<?php
/**
 * read_headers.tpl
 *
 * Template to display the envelope headers when viewing a message.
 * 
 * The following variables are available in this template:
 * 
 *    $headers_to_display - Array containing the list of all elements that need
 *                          to be displayed.  The index of each element is the
 *                          translated name of the field to be displayed.  The
 *                          value of each element is the value to be displayed
 *                          for that field.  Many values can be controled through
 *                          additional templates.
 * 
 *
 * @copyright &copy; 1999-2006 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: read_headers.tpl 12407 2007-05-18 06:23:33Z pdontthink $
 * @package squirrelmail
 * @subpackage templates
 */

/** add required includes **/

/** extract template variables **/
extract($t);

/** Begin template **/
?>
<div class="readHeaders">
 <?php
    foreach ($headers_to_display as $field_name=>$value) {
        if (empty($value)) {
            # Skip enpty headers
            continue;
        }
        ?>
<div style="white-space:nowrap">
  <span class="fieldName">
   <?php echo $field_name; ?>:
  </span>
  <span class="fieldValue">
   <?php echo $value; ?>
  </span>
</div>
<?php
    }
    if (!empty($plugin_output['read_body_header'])) echo $plugin_output['read_body_header'];
?>
</div>
<hr />
