<?php
/**
 * read_menubar_buttons.tpl
 *
 * Tempalte for displaying the action buttons, e.g. Reply, Reply All, Forward,
 * etc., while reading a message.  When combined with the read_menubar_nav template,
 * the entire menu bar is displayed.
 * 
 * The following variables are available in this template:
 *    $nav_on_top       - boolean TRUE if the navigation buttons are on top of the
 *                        action buttons generated here.
 *    $prev_href        - URL to move to the previous message.  Empty if not avilable.
 *    $up_href          - URL to move up in the message.  Empty if not available.
 *    $next_href    - URL to move to the next nessage.  Empty when N/A.
 *    $del_prev_href - URL to delete this message and move to the next one.  Empty if N/A.
 *    $del_next_href - URL to delete this message and move to the next one.  Empty if N/A.
 *    $view_msg_href - URL to go back to the main message.  Empty if N/A.
 *    $msg_list_href - URL to go to the message list.
 *    $search_href   - URL to go back to the serach results.  Empty if N/A.
 *    $form_extra    - Extra elements that will be added to the <form> tag verbatim
 *    $form_method   - The value of the <form>'s method attribute (optional, may be blank)
 *    $form_target   - The value of the <form>'s target attribute (optional, may be blank)
 *    $form_onsubmit - The value of the <form>'s onsubmit handler (optional, may be blank)
 *    $compose_href  - Base URL to forward, reply, etc.  Note that a specific action
 *                     must also be given by the form or in this URL.
 *    $button_onclick - Onclick event string for all buttons
 *    $forward_as_attachment_enabled - boolean TRUE if forwarding as attachments
 *                     has been enabled.
 *    $can_resume_draft - boolean TRUE if the "resume draft" is legitimate for
 *                     this message.
 *    $can_edit_as_new - boolean TRUE if the "reasume as new" action is legitimate
 *                     for this message
 *    $mailboxes     - array containing list of mailboxes available for move/copy action.
 *    $can_be_deleted - boolean TRUE if this message can be deleted.
 *    $can_be_moved  - boolean TRUE if this message can be moved.
 *    $cab_be_copied - boolean TRUE if this message can be copied to another folder.
 *    $move_delete_form_action - the value for the ACTION attribute of forms to
 *                     move, copy or delete a message
 *    $delete_form_extra - additional input elements needed by the DELETE form
 *    $move_form_extra - additional input elements needed by the MOVE form.
 *    $last_move_target - the last folder that a message was moved/copied to. 
 *    
 *
 * @copyright &copy; 1999-2006 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: read_menubar_buttons.tpl 12558 2007-07-20 11:33:00Z jervfors $
 * @package squirrelmail
 * @subpackage templates
 */

/** add required includes **/

/** extract template variables **/
extract($t);

/*FIXME: This is a place where Marc's idea for putting all the buttons and 
         links and other widgets into an array is sorely needed instead of
         hard-coding everything.  Whomever implements that, PLEASE, PLEASE
         look at how the preview pane plugin code is used in this same template
         file for the *default_advanced* set to change some links and buttons 
         and make sure your implementation can support it (tip: it may or may 
         not be OK to let a plugin do the modification of the widgets, since 
         a template set can turn on the needed plugin, but that might not be 
         the most clear way to solve said issue).*/


/** Begin template **/
if ($nav_on_top)
	return;

$plugin_hook = 'read_body_menu_buttons_bottom';

?>

<div class="readMenuBar">
<hr />
<?php

if ($can_resume_draft) {
	echo '<a href="'.$compose_href.'&amp;smaction_draft=1">' .
		_("Resume Draft") .
		"</a><br />\n";
} else if ($can_edit_as_new) {
	echo '<a href="'.$compose_href.'&amp;smaction_edit_new=1">' .
		_("Edit Message as New") .
		"</a><br />\n";
}

echo '<a href="'.$compose_href.'&amp;smaction_reply=1">' .
	_("Reply") .
	"</a>";
echo ' (<a href="'.$compose_href.'&amp;smaction_reply_all=1">' .
	_("Reply All") .
	"</a>)<br />\n";
echo '<a href="'.$compose_href.'&amp;smaction_forward=1">' .
	_("Forward") .
	"</a>\n";

if ($forward_as_attachment_enabled) {
	echo ' (<a href="'.$compose_href.'&amp;smaction_forward=1&amp;smaction_attache=1">' .
		_("As Attachment") .
		"</a>)\n";
}
echo "<br />\n";

if ($can_be_deleted) {
	echo '<a href="'.$move_delete_form_action.'&amp;delete=1">' .
		_("Delete") . "</a>\n";
	echo ' (<a href="'.$move_delete_form_action.'&amp;delete=1&amp;">' .
		_("Bypass Trash") . "</a>)\n";
}
	
echo "<br />\n";

?>
   <?php if(!empty($plugin_output[$plugin_hook])) echo $plugin_output[$plugin_hook]; ?>
  </td>
  <td class="move">
   <?php
    if ($can_be_moved) {
        ?>
    <form name="moveMessageForm" action="<?php echo $move_delete_form_action; ?>" method="post">
     <?php echo $move_form_extra; ?>
     <?php echo _("Move To"); ?>:
     <select name="targetMailbox">
     <?php
        foreach ($mailboxes as $value=>$option) {
            echo '<option value="'. $value .'"' . ($value==$last_move_target ? ' selected="selected"' : '').'>' . $option .'</option>'."\n";
        }
     ?>
     </select>
     <input type="submit" name="moveButton" value="<?php echo _("Move"); ?>" />
     <?php
        if ($can_be_copied) {
            ?>
     <input type="submit" name="copyButton" value="<?php echo _("Copy"); ?>" />
            <?php
        }
     ?>
    </form>
        <?php
    }
   ?>
  </td>
 </tr>
</table>
</div>
